<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function admin()
    {
        return $this->belongsTo('App\Models\Admin');
    }

    public function area()
    {
        return $this->belongsTo('App\Models\Area');
    }

    public function specializations()
    {
        return $this->belongsToMany('App\Models\Specialization');
    }

}